<?php

namespace \App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Advertiser extends Model 
{

    protected $table = 'advertiser';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function product()
    {
        return $this->hasMany('\App\Models\Product');
    }

    public function contact()
    {
        return $this->hasMany('App\Models\Advertiser\Contact2');
    }

}